% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBB.R
\name{plotLBB}
\alias{plotLBB}
\title{Plotting LBB fit}
\usage{
plotLBB(lfq, GausSel = FALSE, LcUser = NA, mmUser = FALSE, MKUser = NA,
  LstartUser = NA)
}
\arguments{
\item{lfq}{A list of the class "lfq" consisting of following parameters:
\itemize{
  \item \strong{species} species name,
  \item \strong{stock} stock ID or name,
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row)
     and sampling date (column),
  \item \strong{comments} comments;
}}

\item{GausSel}{Logical; indicating the selectivity pattern. If FALSE (default) trawl-like,
if TRUE gaussian selectivity is assumed.}

\item{LcUser}{Optional, user defined selectivity parameter. If NA (default) L10 and L90 are
used to estimate a proxy for Lc.}

\item{mmUser}{Logical; indicating the unit of length measurements, where TRUE
indicates that lengths are in mm and FALSE (default) indicate that lengths are in cm.}

\item{MKUser}{Optional; user defined MK ratio. If NA (default) MK ratio is set to 1.5.}

\item{LstartUser}{Optional, user defined length at which selectivity is 0.95. If NA (default)
Lstart (L95) is estimated by the model.}
}
\description{
Function to plot data and fit of a LBB assessment
}
\details{
Plot aggregated histogram with fit to fully selected part.
}
\references{
R. Froese, H. Winker, G. Coro, N. Demirel, A.C. Tsikliras, D. Dimarchopoulou,
G. Scarcella, W.N. Probst, M. Dureuil, and D. Pauly (2018) A new approach
for estimating stock status from length frequency data. ICES Journal of Marine Science. DOI: 10.1093/icesjms/fsy078
}
