% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqModify.R
\name{lfqModify}
\alias{lfqModify}
\title{Modify lfq data for further analysis}
\usage{
lfqModify(lfq, par = NULL, bin_size = NA, vectorise_catch = FALSE,
  plus_group = FALSE)
}
\arguments{
\item{lfq}{lfq object with dates, midLengths, and catch}

\item{par}{growth parameter as resulting from e.g. \code{\link{ELEFAN}}}

\item{bin_size}{Bin size for length frequencies (in cm)}

\item{vectorise_catch}{logical; indicating if the catch matrix should be summarised to
yearly vectors (default: FALSE).}

\item{plus_group}{logical or numeric; should a plus group be created? If yes you will be
asked to insert the length for the plus group in the console (default: FALSE).
Instead of inserting the length of the plus group via the console, the value
can be inserted, e.g. plus_group = 85.5.}
}
\value{
lfq object with rearranged catch matrix (yearly sums) and growth parameters
   if provided.
}
\description{
Modify length-freqeuncy (LFQ) data. Allows to summarise catch matrix
   of LFQ data to one column per year. This is required for e.g. \code{\link{catchCurve}}.
   Allows to change bin size of LFQ data. Allows to ad plus group to catch matrix.
}
\examples{
data(synLFQ4)

## summarise catch matrix per year
lfq_sum <- lfqModify(synLFQ4, vectorise_catch = TRUE)

## change bin size
lfq_bin <- lfqModify(synLFQ4, bin_size = 4)

## add plus_group
lfq_plus <- lfqModify(synLFQ4, plus_group = 85.5)

}
\keyword{function}
\keyword{length-frequency}
\keyword{lfq}
