#' @name bream
#'
#' @title bream data
#'
#' @description Data of a covered codend experimental catch of the species Threadfin bream
#'    (\emph{Nemipterus japonicus}) in South China Sea. This data can be analysed with
#'    the function \code{\link{select}}.
#'
#' @docType data
#'
#' @format A list consiting of:
#' \itemize{
#'   \item \code{midLengths}  the midlengths of size classes,
#'   \item \code{numCodend}  the number of fish retained in codend,
#'   \item \code{numCover}  the number of fish retained in cover,
#'   \item \code{msCodend}  the meshsize of codend.
#' }
#'
#' @source Jones, R., 1976. Mesh regulation in the demersal fisheries of the South
#' China Sea area. Manila, South China Sea Fisheries Development and Coordinating
#' Programme, SCS/76/WP/34: 75 p.
#'
#' @usage data(bream)
#'
#' @keywords data dataset selectivity trawl
#'
#' @examples
#' data(bream)
#' str(bream)
#' summary(bream)
#'
NULL
