% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveThreeStateModel.R
\name{solveThreeStateModel}
\alias{solveThreeStateModel}
\title{Solve Parameters in a Three-State Ill-Death Model}
\usage{
solveThreeStateModel(
  median_pfs,
  median_os,
  corr,
  h12 = seq(0.05, 0.2, length.out = 50)
)
}
\arguments{
\item{median_pfs}{numeric. Median of PFS.}

\item{median_os}{numeric. Median of OS.}

\item{corr}{numeric vector. Pearson correlation coefficients between PFS and OS.}

\item{h12}{numeric vector. A set of hazard from progression to
death that may induce the target correlation \code{corr} given \code{median_pfs}
and \code{median_os}. \code{solveThreeStateModel()} will do a grid search to
find the best hazard parameters that matches to the medians of PFS and OS,
and their correlations.}
}
\value{
a data frame with columns:
\describe{
\item{\code{corr}}{target Peason's correlation coefficients. }
\item{\code{h01}}{hazard from stable to progression. }
\item{\code{h02}}{hazard from stable to death.  }
\item{\code{h12}}{hazard from progression to death. }
\item{\code{error}}{absolute error between target correlation and correlation
derived from \code{h01}, \code{h02}, and \code{h12}. }
}
}
\description{
The ill-death model consists of three states, \code{initial}, \code{progression},
and \code{death}. It can be used to model the progression-free survival (PFS)
and overall survival (OS) in clinical trial simulation. It models the
correlation PFS and OS without assumptions on latent status and copula.
Also, it does not assume PFS and OS satisfy the proportional hazard assumption
simultaneously. The three-state ill-death model ensures a nice property that
PFS <= OS with probability one. However, it requires three hazard parameters
under the homogeneous Markov assumption. In practice, hazard parameters are
hard to specify intuitively especially when no trial data is available at
the planning stage.

This function reparametrizes the ill-death model in term of three parameters,
i.e. median of PFS, median of OS, and correlation between PFS and OS. The
output of this function, which consists of the three hazard parameters, can
be used to generate PFS and OS with desired property. It can be used with
the built-in data generator \code{CorrelatedPfsAndOs3()} when defining
endpoints in \code{TrialSimulator}.

For more information, refer to
\href{https://zhangh12.github.io/TrialSimulator/articles/simulatePfsAndOs.html}{this vignette}.
}
\examples{

dat <- CorrelatedPfsAndOs3(1e6, h01 = .1, h02 = .05, h12 = .12)

cor(dat$pfs, dat$os) ## 0.65

median(dat$pfs) ## 4.62

median(dat$os) ## 9.61

## find h01, h02, h12 that can match to median_pfs, median_os and corr
## should be close to h01 = 0.10, h02 = 0.05, h12 = 0.12 when corr = 0.65
ret <- solveThreeStateModel(median_pfs = 4.6, median_os = 9.6,
                            corr = seq(.5, .7, length.out=5))
ret

}
