% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trial_sequence.R
\name{set_outcome_model}
\alias{set_outcome_model}
\alias{set_outcome_model,trial_sequence-method}
\alias{set_outcome_model,trial_sequence_ITT-method}
\alias{set_outcome_model,trial_sequence_PP-method}
\alias{set_outcome_model,trial_sequence_AT-method}
\title{Specify the outcome model}
\usage{
set_outcome_model(object, ...)

\S4method{set_outcome_model}{trial_sequence}(
  object,
  treatment_var = ~0,
  adjustment_terms = ~1,
  followup_time_terms = ~followup_time + I(followup_time^2),
  trial_period_terms = ~trial_period + I(trial_period^2),
  model_fitter = stats_glm_logit(save_path = NA)
)

\S4method{set_outcome_model}{trial_sequence_ITT}(
  object,
  adjustment_terms = ~1,
  followup_time_terms = ~followup_time + I(followup_time^2),
  trial_period_terms = ~trial_period + I(trial_period^2),
  model_fitter = stats_glm_logit(save_path = NA)
)

\S4method{set_outcome_model}{trial_sequence_PP}(
  object,
  adjustment_terms = ~1,
  followup_time_terms = ~followup_time + I(followup_time^2),
  trial_period_terms = ~trial_period + I(trial_period^2),
  model_fitter = stats_glm_logit(save_path = NA)
)

\S4method{set_outcome_model}{trial_sequence_AT}(
  object,
  treatment_var = "dose",
  adjustment_terms = ~1,
  followup_time_terms = ~followup_time + I(followup_time^2),
  trial_period_terms = ~trial_period + I(trial_period^2),
  model_fitter = stats_glm_logit(save_path = NA)
)
}
\arguments{
\item{object}{A trial_sequence object}

\item{...}{Parameters used by methods}

\item{treatment_var}{The treatment term, only used for "as treated" estimands. PP and ITT are fixed to use
"assigned_treatment".}

\item{adjustment_terms}{Formula terms for any covariates to adjust the outcome model.}

\item{followup_time_terms}{Formula terms for \code{followup_time}, the time period relative to the start of the trial.}

\item{trial_period_terms}{Formula terms for \code{trial_period}, the time period of the start of the trial.}

\item{model_fitter}{A \code{te_model_fitter} object, e.g. from \code{stats_glm_logit()}.}
}
\value{
A modified \code{object} with the \code{outcome_model} slot set
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The time-to-event model for \code{outcome} is specified with this method. Any adjustment terms can be specified.
For ITT and PP estimands the \code{treatment_var} is not specified as it is automatically defined as
\code{assigned_treatment}. Importantly, the modelling of "time" is specified in this model with arguments for
trial start time and follow up time within the trial.
}
\examples{
trial_sequence("ITT") |>
  set_data(data_censored) |>
  set_outcome_model(
    adjustment_terms = ~age_s,
    followup_time_terms = ~ stats::poly(followup_time, degree = 2)
  )

}
