% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{trial_msm}
\alias{trial_msm}
\title{Fit the Marginal Structural Model for the Sequence of Trials}
\usage{
trial_msm(
  data,
  outcome_cov = ~1,
  model_var = NULL,
  first_followup = NA,
  last_followup = NA,
  use_weight = FALSE,
  analysis_weights = c("asis", "unweighted", "p99", "weight_limits"),
  weight_limits = c(0, Inf),
  use_censor = FALSE,
  include_followup_time = ~followup_time + I(followup_time^2),
  include_trial_period = ~trial_period + I(trial_period^2),
  where_case = NA,
  glm_function = c("glm", "parglm"),
  use_sample_weights = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing all the required columns.}

\item{outcome_cov}{A RHS formula with baseline covariates to adjust in final model}

\item{model_var}{List of Variables of interest to be used in final model.
Derived variables to use in outcome models. Typically \code{assigned_treatment} for ITT and per-protocol,
and \code{dose + dose^2} for as-treated.}

\item{first_followup}{First follow-up period}

\item{last_followup}{Last follow-up period}

\item{use_weight}{Use weights in analysis. If \code{FALSE} then no weights will be calculated.}

\item{analysis_weights}{One of
\itemize{
\item \code{"asis"}: use the weights as calculated
\item \code{"p99"}: truncate weights at the 1st and 99th percentiles
\item \code{"weight_limits"}: truncate weights at the values specified in \code{weight_limits}
\item \code{"unweighted"}: set all analysis weights to 1, even with \code{use_weight = TRUE}
}}

\item{weight_limits}{Lower and upper limits to truncate weights, given as \code{c(lower, upper)}}

\item{use_censor}{Use censoring for per-protocol analysis - censor person-times once a person-trial stops taking the
initial treatment value}

\item{include_followup_time}{The model to include the follow up time of the trial (\code{followup_time}) in outcome model,
specified as a RHS formula.}

\item{include_trial_period}{The model to include the trial period (\code{trial_period}) in outcome model,
specified as a RHS formula.}

\item{where_case}{List of where conditions used in subsetting the data used in final analysis}

\item{glm_function}{Which glm function to use for the final model from \code{stats} or \code{parglm} packages}

\item{use_sample_weights}{Use sample weights in addition to IP weights. \code{data} must contain a column \code{sample_weight}.
The weights used in the model are calculated as \code{weight = weight * sample_weight}.}

\item{quiet}{Don't print progress messages.}

\item{...}{Additional arguments passed to \code{glm_function}. This may be used to specify initial parameter estimates
or arguments to \code{control}. See \link[stats:glm]{stats::glm}, \link[parglm:parglm]{parglm::parglm} and \code{\link[parglm:parglm.control]{parglm::parglm.control()}} for more information.}
}
\value{
Object of class \code{TE_msm} containing
\describe{
\item{model}{a \code{glm} object}
\item{robust}{a list containing a coefficient summary table and the robust covariance \code{matrix}}
}
}
\description{
Fits a weighted pooled logistic regression model for the sequence of trials and
calculates a robust covariance matrix using a sandwich estimator.
}
\details{
The model formula is constructed by combining the arguments \code{outcome_cov}, \code{model_var},
\code{include_followup_time}, and \code{include_trial_period}.
}
