% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initiators.R
\name{initiators}
\alias{initiators}
\title{Initiators Analysis}
\usage{
initiators(
  data,
  id = "id",
  period = "period",
  treatment = "treatment",
  outcome = "outcome",
  eligible = "eligible",
  outcome_cov = ~1,
  model_var = NULL,
  switch_n_cov = ~1,
  switch_d_cov = ~1,
  first_period = NA,
  last_period = NA,
  first_followup = NA,
  last_followup = NA,
  use_weight = FALSE,
  save_weight_models = FALSE,
  analysis_weights = c("asis", "unweighted", "p99", "weight_limits"),
  weight_limits = c(0, Inf),
  use_censor = FALSE,
  cense = NA,
  pool_cense = FALSE,
  cense_d_cov = ~1,
  cense_n_cov = ~1,
  include_followup_time = ~followup_time + I(followup_time^2),
  include_trial_period = ~trial_period + I(trial_period^2),
  eligible_wts_0 = NA,
  eligible_wts_1 = NA,
  where_var = NULL,
  where_case = NA,
  data_dir,
  glm_function = "glm",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing all the required columns.}

\item{id}{Name of the data column for id feature Defaults to id}

\item{period}{Name of the data column for period feature Defaults to period}

\item{treatment}{Name of the data column for treatment feature Defaults to treatment}

\item{outcome}{Name of the data column for outcome feature Defaults to outcome}

\item{eligible}{Indicator of whether or not an observation is eligible to be expanded about Defaults to eligible}

\item{outcome_cov}{A RHS formula with baseline covariates to adjust in final model}

\item{model_var}{List of Variables of interest to be used in final model.
Derived variables to use in outcome models. Typically \code{assigned_treatment} for ITT and per-protocol,
and \code{dose + dose^2} for as-treated.}

\item{switch_n_cov}{A RHS formula for modelling probability of switching treatment. Used in the numerator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{switch_d_cov}{A RHS formula for modelling probability of switching treatment. Used in the denominator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{first_period}{First time period to include as trial baseline in expanded data}

\item{last_period}{Last time period to include as trial baseline in expanded data}

\item{first_followup}{First follow-up period}

\item{last_followup}{Last follow-up period}

\item{use_weight}{Use weights in analysis. If \code{FALSE} then no weights will be calculated.}

\item{save_weight_models}{Save weight models objects in \code{data_dir}.}

\item{analysis_weights}{One of
\itemize{
\item \code{"asis"}: use the weights as calculated
\item \code{"p99"}: truncate weights at the 1st and 99th percentiles
\item \code{"weight_limits"}: truncate weights at the values specified in \code{weight_limits}
\item \code{"unweighted"}: set all analysis weights to 1, even with \code{use_weight = TRUE}
}}

\item{weight_limits}{Lower and upper limits to truncate weights, given as \code{c(lower, upper)}}

\item{use_censor}{Use censoring for per-protocol analysis - censor person-times once a person-trial stops taking the
initial treatment value}

\item{cense}{Censoring variable}

\item{pool_cense}{Fit pooled or separate censoring models for those treated and
those untreated at the immediately previous visit.
(default is \code{FALSE}, separate numerator and denominator models for treatment groups)}

\item{cense_d_cov}{A RHS formula for modelling probability of being censored. Used in the numerator of weight
calculation.}

\item{cense_n_cov}{A RHS formula for modelling probability of being censored. Used in the denominator of weight
calculation.}

\item{include_followup_time}{The model to include the follow up time of the trial (\code{followup_time}) in outcome model,
specified as a RHS formula.}

\item{include_trial_period}{The model to include the trial period (\code{trial_period}) in outcome model,
specified as a RHS formula.}

\item{eligible_wts_0}{Eligibility criteria used in weights for model condition Am1 = 0}

\item{eligible_wts_1}{Eligibility criteria used in weights for model condition Am1 = 1}

\item{where_var}{List of variables used in where conditions used in subsetting the data used in final analysis
(where_case), the variables not included in the final model}

\item{where_case}{List of where conditions used in subsetting the data used in final analysis}

\item{data_dir}{Directory to save model objects in.}

\item{glm_function}{Which glm function to use for the final model from \code{stats} or \code{parglm} packages}

\item{quiet}{Don't print progress messages.}

\item{...}{Additional arguments passed to \code{glm_function}. This may be used to specify initial parameter estimates
or arguments to \code{control}. See \link[stats:glm]{stats::glm}, \link[parglm:parglm]{parglm::parglm} and \code{\link[parglm:parglm.control]{parglm::parglm.control()}} for more information.}
}
\value{
Returns the result of \code{\link[=trial_msm]{trial_msm()}} on the expanded data.
An object of class \code{TE_msm} containing
\describe{
\item{model}{a \code{glm} object}
\item{robust}{a list containing a coefficient summary table and the robust covariance \code{matrix}}
}
}
\description{
An all-in-one analysis using a sequence of target trials. This provides a simplified
interface to the main working functions \code{\link[=data_preparation]{data_preparation()}} and \code{\link[=trial_msm]{trial_msm()}}.
}
\details{
If \code{model_var = NULL} the package will add some terms to the outcome model:
\itemize{
\item if \code{use_censor = FALSE} and \code{use_weight = FALSE}, an as-treated analysis will be done the outcome model will have
\code{~ dose + I(dose^2)} terms added
\item if \code{use_censor = TRUE}, a per-protocol analysis will be done with an \code{~assigned_treatment} term added
\item if \code{use_censor = FALSE} and \code{use_weight = TRUE}, an intention to treat analysis will be done with an
\code{~assigned_treatment} term added
}
}
