% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriadSim_functions.R
\name{get.brks}
\alias{get.brks}
\title{Picking chromosomal breaking points}
\usage{
get.brks(N.brk, n.ped, snp.all2, target.snp, rcmb.rate = NA,
  same.brk = FALSE)
}
\arguments{
\item{N.brk}{is either an integer or a vector of integers. If it is a single integer it gives the number of breaks to be picked 
for each chromosome and all chromosomes will have the same number of break points. If it is an vector of integers it should be of the
same length as the number of chromosomes, each number giving the number of break points of the corresponding chromosomes. The chromosomes
are asssumed to be ordered by chromosome number.}

\item{n.ped}{is an integer giving the number of trios to be simulated}

\item{snp.all2}{is a dataframe containing the list of SNPs in PLINK .bim format. Two columns of the dataframe
is used: the column with column name "CHR" containing the chromosome number and the column with column name "POS"
containing the chromosomal postion of the SNPs.}

\item{target.snp}{is a vector of integers showing the row number of the target SNPs in the .bim file.}

\item{rcmb.rate}{the default value is NA. rcmb.rate is a dataframe containing the recombination rates at each SNP. The ordering of the SNPs should 
be identical to that of snp.all2. It contains 4 columns with column names 'CHR','RS','POS',and 'RATE with the 
corresponding values for "the chromosomal number", "SNP rs number", "chromosomal position",
and "recombination rate". The recombination rate represents the maximum recombination rate in the chromosomal
region between the current SNP and the SNP above (or the first basepair of the chromosome for the first SNP on a chromosome).
When no rcmb.rate is provided the function will pick the breaking points randomly where keeping the breaking
points in between target SNPs. An example recombination rate data frame "rcmb.rate" is already loaded with the package.}

\item{same.brk}{is an indicator variable to denote whethere the same set of breaking points will be used for all simulated triads}
}
\value{
A list of two elements is returned. The first one is a matrix of integers showing where 
the chromosomal breaks is to take place for each individuals in the simulated trios. The second one
is a matrix showing the chromosomal segments out of which each target SNP is selected for each simulated trio.
}
\description{
The breaking points at each chromosome can be picked manually or use this function. 
When a data frame containing the recombination rates (rcmb.rate) is provided the function
tends to pick the breaking points at recombination hotspots.
}
\examples{
tar.snp <- c(21, 118, 121, 140, 155, 168, 218, 383) 
found.brks <- get.brks(N.brk=3,n.ped=1000, snp.all2, tar.snp,rcmb.rate=NA)
breaks <- found.brks[[1]]
family.pos <- found.brks[[2]] 


}

