% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{TreesMatchingSplit}
\alias{TreesMatchingSplit}
\alias{LnTreesMatchingSplit}
\alias{Log2TreesMatchingSplit}
\title{Number of trees matching a bipartition split}
\usage{
TreesMatchingSplit(A, B = A[2])

LnTreesMatchingSplit(A, B = A[2])

Log2TreesMatchingSplit(A, B = A[2])
}
\arguments{
\item{A, B}{Integer specifying the number of taxa in each partition.}
}
\value{
\code{TreesMatchingSplit()} returns a numeric specifying the number of trees
that are compatible with the given split.

\code{LnTreesMatchingSplit()} and \code{Log2TreesMatchingSplit()} give the natural
and base-2 logarithms of this number.
}
\description{
Calculates the number of unrooted bifurcated trees that are consistent with
a bipartition split that divides taxa into groups of size \code{A} and \code{B}.
}
\examples{
TreesMatchingSplit(5, 6)
LnTreesMatchingSplit(5, 6)
Log2TreesMatchingSplit(5, 6)

}
\seealso{
Other split information functions: 
\code{\link{CharacterInformation}()},
\code{\link{SplitInformation}()},
\code{\link{SplitMatchProbability}()},
\code{\link{UnrootedTreesMatchingSplit}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split information functions}
