% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{EdgeAncestry}
\alias{EdgeAncestry}
\title{Edge ancestry}
\usage{
EdgeAncestry(edge, parent, child, stopAt = (parent == min(parent)))
}
\arguments{
\item{edge}{Integer specifying the number of the edge whose child edges
should be returned.}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 2]}.}

\item{stopAt}{Integer or logical vector specifying the edge(s) at which to
terminate the search; defaults to the edges with the smallest parent,
which will be the root edges if nodes are numbered cladewise or in Preorder.}
}
\value{
\code{EdgeAncestry} returns a logical vector stating whether each edge in
turn is a descendant of the specified edge.
}
\description{
Quickly identify edges that are 'ancestral' to a particular edge in a tree.
}
\examples{
tree <- PectinateTree(6)
plot(tree)
ape::edgelabels()
parent <- tree$edge[, 1]
child <- tree$edge[, 2]
EdgeAncestry(7, parent, child)
which(EdgeAncestry(7, parent, child, stopAt = 4))

}
\seealso{
Other tree navigation: 
\code{\link{AllAncestors}()},
\code{\link{AncestorEdge}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeDistances}()},
\code{\link{MRCA}()},
\code{\link{NonDuplicateRoot}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
