% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{DescendantEdges}
\alias{DescendantEdges}
\alias{AllDescendantEdges}
\title{Descendant Edges}
\usage{
DescendantEdges(edge, parent, child, nEdge = length(parent))

AllDescendantEdges(parent, child, nEdge = length(parent))
}
\arguments{
\item{edge}{Integer specifying the number of the edge whose child edges are
required (see \code{\link[ape:nodelabels]{edgelabels}}).}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 2]}.}

\item{nEdge}{number of edges (calculated from \code{length(parent)} if not
supplied).}
}
\value{
\code{DescendantEdges} returns a logical vector stating whether each edge
in turn is a descendant of the specified edge (or the edge itself).

\code{AllDescendantEdges} returns a matrix of class logical, with row N
specifying whether each edge is a descendant of edge N (or the edge itself).
}
\description{
Quickly identify edges that are 'descended' from a particular edge in a tree.
}
\section{Functions}{
\itemize{
\item \code{AllDescendantEdges}: Quickly identifies edges that are 'descended'
from each edge in a tree.
}}

\seealso{
Other tree navigation: 
\code{\link{AllAncestors}()},
\code{\link{AncestorEdge}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{MRCA}()},
\code{\link{NonDuplicateRoot}()}
}
\concept{tree navigation}
