% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{TipsInSplits}
\alias{TipsInSplits}
\title{Tips contained within splits}
\usage{
TipsInSplits(splits, nTip = attr(splits, "nTip"))
}
\arguments{
\item{splits}{Object of class \code{Splits}.}

\item{nTip}{Number of tips in \code{Splits} object (inferred if not specified).}
}
\value{
A named vector of integers, specifying the number of tips contained
within each split in \code{splits}.
}
\description{
\code{TipsInSplits} specifies the number of tips that occur within each
bipartition split in a \code{Splits} object.
}
\examples{
splits <- as.Splits(PectinateTree(8))
TipsInSplits(splits)

}
\seealso{
Other Splits operations: \code{\link{NSplits}},
  \code{\link{NTip}}, \code{\link{TipLabels}},
  \code{\link{as.Splits}}, \code{\link{in.Splits}},
  \code{\link{match.Splits}}
}
\concept{Splits operations}
