% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{UniqueSplits}
\alias{UniqueSplits}
\title{Unique Splits}
\usage{
UniqueSplits(splits, preserveParity = FALSE)
}
\arguments{
\item{splits}{A vector of integers listing the number of tips in each of a number of 
tree splits (e.g. bipartitions).  For example, \kbd{c(3, 5)} states that 
a character divides a set of eight tips into a group of three and a group
of five.}

\item{preserveParity}{Logical specifying whether to preserve the `TRUE` and
`FALSE` status within each split (which takes marginally longer).  If 
`FALSE`, each split will be defined such that taxa in the same partition
as the first element are marked `FALSE`, and other taxa marked `TRUE`.}
}
\value{
The splits element, with all duplicate splits removed.
}
\description{
Removes equivalent duplicates from a matrix of bipartitions.
}
\examples{
  set.seed(1)
  splits <- Tree2Splits(ape::rtree(6, br=NULL))
  UniqueSplits(splits, preserveParity=TRUE)

}
\author{
Martin R. Smith
}
