% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsInventory}
\alias{tlsInventory}
\title{Extract forest inventory metrics from a point cloud}
\usage{
tlsInventory(
  las,
  dh = 1.3,
  dw = 0.5,
  hp = 1,
  d_method = shapeFit(shape = "circle", algorithm = "ransac", n = 15, n_best = 20)
)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{dh}{\code{numeric} - height layer (above ground) to estimate stem diameters, in point cloud units.}

\item{dw}{\code{numeric} - height layer width, in point cloud units.}

\item{hp}{\code{numeric} - height percentile to extract per tree (0-1). Use 1 for top height, i.e. the highest point.}

\item{d_method}{parameterized \code{\link{shapeFit}} function, i.e. method to use for diameter estimation.}
}
\description{
Estimation of diameter and height tree-wise for normalized point clouds with assigned stem points.
}
\examples{
\donttest{
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  tlsSample

map = treeMap(tls, map.hough())
tls = treePoints(tls, map, trp.crop(circle=FALSE))
tls = stemPoints(tls, stm.hough())

dmt = shapeFit(shape = 'circle', algorithm='ransac', n=20)
inv = tlsInventory(tls, d_method = dmt)
tlsPlot(tls, inv)
}
}
