% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_path.R
\name{PathDist}
\alias{PathDist}
\title{Path distance}
\usage{
PathDist(tree1, tree2 = NULL)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}
}
\value{
\code{PathDist()} returns a vector or distance matrix of distances
between trees.
}
\description{
Calculate the path distance between trees.
}
\details{
This function is a wrapper for the function
\code{\link[phangorn:treedist]{path.dist()}} in the phangorn package.
It pre-processes trees to ensure that their internal representation does
not cause the \code{path.dist()} function to crash R.

The path distance is also termed the cladistic difference or topological
distance.

Use of the path distance is discouraged as it emphasizes
shallow relationships at the expense of deeper (and arguably more
fundamental) relationships (Farris, 1973).
}
\examples{
library('TreeTools')

PathDist(BalancedTree(7), PectinateTree(7))

PathDist(BalancedTree(7), as.phylo(0:2, 7))
PathDist(as.phylo(0:2, 7), PectinateTree(7))

PathDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))

CompareAll(as.phylo(30:33, 8), PathDist)
 
}
\references{
\insertRef{Farris1973}{TreeDist}
}
\seealso{
Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
