% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{add_missing_subjects_row}
\alias{add_missing_subjects_row}
\title{Add a missing subject row into a count summary.}
\usage{
add_missing_subjects_row(e, fmt = NULL, sort_value = NULL)
}
\arguments{
\item{e}{A `count_layer` object}

\item{fmt}{An f_str object used to format the total row. If none is provided,
display is based on the layer formatting.}

\item{sort_value}{The value that will appear in the ordering column for total
rows. This must be a numeric value.}
}
\description{
This function calculates the number of subjects missing from a particular
group of results. The calculation is done by examining the total number of
subjects potentially available from the Header N values within the result
column, and finding the difference with the total number of subjects present
in the result group. Note that for accurate results, the subject variable
needs to be defined using the `set_distinct_by()` function. As with other
methods, this function instructs how distinct results should be identified.
}
\examples{

tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      add_missing_subjects_row(f_str("xxxx", n))
   ) \%>\%
   build()
}
