% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R, R/table_bindings.R
\name{get_where.tplyr_layer}
\alias{get_where.tplyr_layer}
\alias{set_where.tplyr_layer}
\alias{get_where}
\alias{get_where.tplyr_table}
\alias{set_where}
\alias{set_where.tplyr_table}
\alias{set_pop_where}
\alias{get_pop_where}
\title{Set or return where binding for layer or table}
\usage{
\method{get_where}{tplyr_layer}(obj)

\method{set_where}{tplyr_layer}(obj, where)

get_where(obj)

\method{get_where}{tplyr_table}(obj)

set_where(obj, where)

\method{set_where}{tplyr_table}(obj, where)

set_pop_where(obj, where)

get_pop_where(obj)
}
\arguments{
\item{obj}{A \code{tplyr_layer} or \code{tplyr_table} object.}

\item{where}{An expression (i.e. syntax) to be used to subset the data.
Supply as programming logic (i.e. x < 5 & y == 10)}
}
\value{
For \code{where}, the where binding of the supplied object.
  For \code{set_where}, the modified object
}
\description{
Set or return where binding for layer or table
}
\examples{
# Load in pipe
library(magrittr)

iris$Species2 <- iris$Species
lay <- tplyr_table(iris, Species) \%>\%
  group_count(Species) \%>\%
  set_where(Petal.Length > 3) \%>\%
  # Set logic for pop_data as well
  set_pop_where(Petal.Length > 3)

}
