% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layering.R
\name{add_layer}
\alias{add_layer}
\alias{add_layers}
\title{Attach a layer to a \code{tplyr_table} object}
\usage{
add_layer(parent, layer, name = NULL)

add_layers(parent, ...)
}
\arguments{
\item{parent}{A \code{tplyr_table} or \code{tplyr_layer}/\code{tplyr_subgroup_layer} object}

\item{layer}{A layer construction function and associated modifier functions}

\item{name}{A name to provide the layer in the table layers container}

\item{...}{Layers to be added}
}
\value{
A \code{tplyr_table} or \code{tplyr_layer}/\code{tplyr_subgroup_layer} with a new layer inserted into the \code{layer}
  binding


}
\description{
\code{add_layer} attaches a \code{tplyr_layer} to a \code{tplyr_table} object. This allows
for a tidy style of programming (using \code{magrittr} piping, i.e. \code{\%>\%}) with a
secondary advantage - the construction of the layer object may consist of a series of piped
functions itself.

\code{Tplyr} encourages a user to view the construction of a table as a series of "layers".
The construction of each of these layers are isolated and independent of one another - but
each of these layers are children of the table itself. \code{add_layer} isolates the construction
of an individual layer and allows the user to construct that layer and insert it back into the
parent. The syntax for this is intuitive and allows for tidy piping. Simply pipe the current
table object in, and write the code to construct your layer within the \code{layer} parameter.

\code{add_layers} is another approach to attaching layers to a \code{tplyr_table}. Instead of
constructing the entire table at once, \code{add_layers} allows you to construct layers as
different objects. These layers can then be attached into the \code{tplyr_table} all at
once.

\code{add_layer} and \code{add_layers} both additionally allow you to name the layers as you
attach them. This is helpful when using functions like \code{\link{get_numeric_data}} or
\code{\link{get_stats_data}} when you can access information from a layer directly.
\code{add_layer} has a name parameter, and layers can be named in \code{add_layers} by
submitting the layer as a named argument.
}
\examples{
# Load in pipe
library(magrittr)

## Single layer
t <- tplyr_table(mtcars, cyl) \%>\%
  add_layer(
    group_desc(target_var=mpg)
  )

## Single layer with name
t <- tplyr_table(mtcars, cyl) \%>\%
  add_layer(name='mpg',
    group_desc(target_var=mpg)
  )

# Using add_layers
t <- tplyr_table(mtcars, cyl)
l1 <- group_desc(t, target_var=mpg)
l2 <- group_count(t, target_var=cyl)

t <- add_layers(t, l1, 'cyl' = l2)

}
\seealso{
[tplyr_table(), tplyr_layer(), group_count(), group_desc(), group_shift()]
}
\concept{Layer attachment}
