% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_bindings.R
\name{header_n}
\alias{header_n}
\alias{header_n<-}
\alias{set_header_n}
\title{Return or set header_n binding}
\usage{
header_n(table)

header_n(x) <- value

set_header_n(table, value)
}
\arguments{
\item{table}{A \code{tplyr_table} object}

\item{x}{A \code{tplyr_table} object}

\item{value}{A named numeric vector. Names of vector should match treatment
group names.}

\item{header_n}{A named numeric vector. Names of vector should match treatment
group names.}
}
\value{
For \code{tplyr_header_n} the header_n binding of the
  \code{tplyr_table} object. For \code{tplyr_header_n<-} and
  \code{set_tplyr_header_n} the modified object.
}
\description{
When the header or table body relies on population count data, the header_n
binding is used for display and calculations.
}
\examples{
tab <- tplyr_table(iris, Species)

header_n(tab) <- c(setosa = 50, versicolor = 50, virginica = 50)

}
