% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roundrobin.R
\name{roundrobin}
\alias{roundrobin}
\title{Create a match schedule}
\usage{
roundrobin(teamvector, second_round = TRUE, match_free = TRUE,
  randomize = TRUE, seed)
}
\arguments{
\item{teamvector}{A character vector of teams.}

\item{second_round}{A logical value, indicating whether a second round with changed home and away team should be planned. Defaults to TRUE.}

\item{match_free}{A logical value, indicating whether match free teams should be deleted from the schedule. Defaults to TRUE.}

\item{randomize}{A logical value, indicating whether the team vector should be ordered randomly. Defaults to TRUE.}

\item{seed}{A user defined integer to replicate the randomization process if randomize = TRUE.}
}
\value{
A data frame containing a match schedule including variables for matchday, home and away team.
}
\description{
Create a match schedule according to the DFB's (German Soccer Association) 'harmonischer Schlüssel-Plan 1-L' which is used as a blueprint for german football leagues.
}
\details{
The applicability is currently restricted to a minimum of five teams.
}
\examples{
require("engsoccerdata")
#get german Bundesliga teams from 1986
germany_1986 <- unique(engsoccerdata::germany[engsoccerdata::germany$Season==1986,"home"])
#replicable schedule
roundrobin(teamvector=germany_1986,second_round=TRUE,match_free=TRUE,randomize=TRUE,seed=1234)
#non replicable schedule
roundrobin(teamvector=germany_1986,second_round=TRUE,match_free=TRUE,randomize=TRUE)
}
\references{
\url{https://portal.dfbnet.org/fileadmin/content/downloads/faq/211111_SZ_DFBnet_extern_mit_Gegenueberstellung4.pdf}
}
