% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TooManyCellsR.R
\name{writeMatrixFiles}
\alias{writeMatrixFiles}
\title{Write a Matrix to a folder.}
\usage{
writeMatrixFiles(mat, labels = NULL)
}
\arguments{
\item{mat}{The input Matrix with gene row names and cell barcode column
names.}

\item{labels}{The input labels data frame with item (cell barcodes) and label
(whatever labels you want to give them, such as tissue of origin, celltype,
etc.) columns. Optional.}
}
\value{
None
}
\description{
This function will write a Matrix from the Matrix library to a temporary
directory containing matrix.mtx, genes.tsv, barcodes.tsv, and optionally a
labels.csv file.
}
\examples{
input <- system.file("extdata", "mat.csv", package="TooManyCellsR")
df = read.csv(input, row.names = 1, header = TRUE)
mat = Matrix::Matrix(as.matrix(df), sparse = TRUE)
writeMatrixFiles(mat)
}
