% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.AdPaik}
\alias{summary.AdPaik}
\title{Summary of the Adapted Paik et al.'s Time-Dependent Shared Frailty Model}
\usage{
\method{summary}{AdPaik}(result)
}
\arguments{
\item{result}{'S3' class object returned by the main model call, i.e. output of the 'Adapted Paik et al.'s Model'.}
}
\value{
Model summary printed on output.
}
\description{
This function provides a comprehensive summary of the results from the Adapted Paik et al.'s Time-Dependent Shared Frailty Model.
It includes key information about the dataset (e.g., number of individuals, regressors, intervals, and clusters), model parameters,
and output (log-likelihood, AIC). The summary also lists the estimated regressors along with their standard errors
}
\details{
The function reports the estimated regressors, their standard errors, and confidence intervals (if available).
}
\examples{
# Define the variables needed for the model execution

data(data_dropout)
eps_paik <- 1e-10
categories_range_min <- c(-8, -2, eps_paik, eps_paik, eps_paik)
categories_range_max <- c(-eps_paik, 0.4, 1 - eps_paik, 1, 10)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
formula <- time_to_event ~ Gender + CFUP + cluster(group)

\donttest{
# Call the main model function
result <- AdPaikModel(formula, data_dropout, time_axis, categories_range_min, categories_range_max)

# Call the summary
summary(result)
}
}
