% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.result.R
\name{check.result}
\alias{check.result}
\title{Internal function to check the structure of the model output}
\usage{
check.result(result)
}
\arguments{
\item{result}{S3 object. Expected to be of class 'AdPaik', 'PowPar', or 'StocTimeDep'.}
}
\value{
Throws an error if the \code{result} object does not belong to one of the expected classes,
or if the object’s structure is incorrect.
}
\description{
This internal function checks if the input \code{result} object belongs to one of the
expected S3 classes ('AdPaik', 'PowPar', or 'StocTimeDep') and calls the
appropriate checking function based on the class.
}
\details{
This function is internal and dispatches the appropriate structure-checking function
based on the class of the input. Currently, it supports 'AdPaik' class. The structure-checking
functions for 'PowPar' and 'StocTimeDep' are placeholders and should be implemented if needed.
}
\keyword{internal}
