% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomizingTree.R
\name{RandomizeDocument}
\alias{RandomizeDocument}
\title{Randomizing documents.}
\usage{
RandomizeDocument(Document, isSectionReordered.vector, isLayerRandomized.vector)
}
\arguments{
\item{Document}{Document to randomize, as generated by \code{\link{StructureDocument}}. The names of the structure are used to determine how to randomize the document.}

\item{isSectionReordered.vector}{Logical vector, specifying if the order of sections should be also randomized at a certain depth level.

\strong{Note} that if \code{isLayerRandomized} is set to false for a certain layer, \code{isSectionReorder} will have no effect. (Probably this isn't the best behaviour)}

\item{isLayerRandomized.vector}{Logical vector, specifying if you should randomize the order of the items, (denoted by \code{\\cmdName}) or not at a certain depth level.

This vector should have the same length as the depth at most, otherwise it will raise an error if you try to "dig deeper than it can". And \emph{isSectionReordered.vector} should have matching elements for each element of \emph{isLayerRandomized.vector}

(Maybe we could change this to a warning instead? To allow for structures with different depths within different branches of the tree)}
}
\value{
A document structure, as provided by \code{\link{StructureDocument}}.

However, the names of the structure will no longer be sequential,
the naming convention in the new structure will refer to the original structure that was inputted into this function. Which is very useful when you want to keep track of where things have moved.
}
\description{
Function to randomize a Document, as created by \code{\link{StructureDocument}}.

It Randomizes each layer according to the prescriptions involved in the internal function \code{\link{GetLayerSampleIndexes}}. Which, in summary, randomizes each section inside, and then randomizes the orders of the sections.

\strong{Important note:} One must provide to this function the \emph{document} part of the structure. Since \code{\link{StructureDocument}} provides as the outer most layer a split between the preamble and the document, one must just supply the document part to this function, (or a subsection of it).
}
\details{
It keeps randomizing recursively inner layers of the structure until it runs out of elements on the logical vectors \code{isSectionReordered.vector} and \code{isLayerRandomized.vector}.

A "section" denotes the content within a begin-end environment in the document.
Each section is then assumed to be divided in a beginning and end parts, that should be fixed in place, and the parts denoted by the command \code{\\cmdName} as explained on \code{\link{StructureDocument}}.

We will denote those parts as "items."
Analogously to itemize environments in 'LaTeX'.

The purpose of this function is therefore to randomize the items from the structure, fixing the begin and end parts within a section. And then to reorder each section while keeping the pre- and post- parts fixed, and to do so recursively until we exhaust the \code{isLayerRandomized.vector}

\code{isSectionReordered.vector} specifies whether to order sections for a certain depth, while \code{isLayerRandomized.vector} specifies whether to order the items within a section of that same depth.

In some cases you may want to reorder the sections, for example, using the examdesign class. Over there, questions use the begin-end question format.

In others cases you may want to preserve the order of sections while still modifying the order of the items, like when you are using the exam class, or when creating your own list of questions with an \code{\\itemize} environment.

For efficiency, if you don't want to randomize to the full depth of your tree, just make those logical vectors of your desired length, rather than making them of length \eqn{n} and then setting every layer after the last one you want to randomize to false. That will prevent the program from walking down the whole tree checking everything.
}
\examples{

rndDoc <- RandomizeDocument(
    TexExamRandomizer::testdoc$document,
    c(FALSE,TRUE),
    c(TRUE, TRUE)
    )
}
\seealso{
\code{\link{StructureDocument}}, TODO: Add reference to extracting info functions
}
