% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisations.R
\name{graphCohort}
\alias{graphCohort}
\title{`graphCohort()` aids in the visualisation of cohorts timelines, useful to get a grip on intersections.}
\usage{
graphCohort(subject_id, cohorts = list())
}
\arguments{
\item{subject_id}{Only one subject id per visualisation}

\item{cohorts}{List of cohorts}
}
\value{
A ggplot graph
}
\description{
`graphCohort()` aids in the visualisation of cohorts timelines, useful to get a grip on intersections.
}
\examples{
hosptalised <- tibble::tibble(cohort_definition_id = 2,
                              subject_id = 1,
                              cohort_start_date = "2018-01-01",
                              cohort_end_date = "2018-01-10")

icu_patients <- tibble::tibble(cohort_definition_id = 5,
                              subject_id = 1,
                              cohort_start_date = "2018-01-02",
                              cohort_end_date = "2018-01-04")

drugs_treatment <- tibble::tibble(cohort_definition_id = 5,
                                  subject_id = 1,
                              cohort_start_date = "2018-01-07",
                              cohort_end_date = "2018-01-09")

TestGenerator::graphCohort(subject_id = 1, cohorts = list("hosptalised" = hosptalised,
                                                      "icu_patients" = icu_patients,
                                                      "drugs_treatment" = drugs_treatment))
}
