% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{multivariate}
\alias{multivariate}
\title{Multivariate Analysis Of Sexual Dimorphism}
\usage{
multivariate(
  x,
  R.res = NULL,
  Trait = 1,
  Pop = 2,
  type_manova = "II",
  manova_test_statistic = "W",
  interact_manova = TRUE,
  es_manova = "none",
  univariate = FALSE,
  padjust = "none",
  ...,
  lower.tail = FALSE,
  CI = 0.95,
  digits = 4
)
}
\arguments{
\item{x}{Data frame or list containing summary statistics for
multiple parameters measured in both sexes in two or more populations.}

\item{R.res}{Pooled within correlation matrix, Default: NULL}

\item{Trait}{Number of the column containing names of measured parameters,
Default: 1}

\item{Pop}{Number of the column containing populations' names, Default: 2}

\item{type_manova}{type of MANOVA test "I","II" or "III", Default:"II".}

\item{manova_test_statistic}{type of test statistic used either "W" for "Wilks","P"
for "Pillai", "HL" for "Hotelling-Lawley" or "R" for "Roy's largest root",
Default: "W".}

\item{interact_manova}{Logical; if TRUE calculates MANOVA for the interaction
effects,Default: TRUE.}

\item{es_manova}{effect size either ,"eta" for eta squared, or "none"for
not reporting an effect size, Default:"none".}

\item{univariate}{Logical; if TRUE conducts multiple univariate analyses on
different parameters separately, Default: FALSE}

\item{padjust}{Method of p.value adjustment for multiple comparisons
following \link[stats]{p.adjust}  Default: "none".}

\item{...}{Additional arguments that could be passed to \link{univariate}}

\item{lower.tail}{Logical; if TRUE probabilities are `P[X <= x]`,
otherwise, `P[X > x]`., Default: FALSE}

\item{CI}{confidence interval coverage for the chosen effect size takes value
from 0 to 1, Default: 0.95.}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
MANOVA table. When the term is followed by `(E)` an exact f-value
is calculated.
}
\description{
Multivariate extension of Greene t test \link{t_greene}
}
\details{
Data can be entered either as a data frame of summary
statistics as in \link{baboon.parms_df}. In that case the pooled within
correlation matrix `R.res` should be entered as a separate argument as in
\link{baboon.parms_R}. Another acceptable format is is a named list of matrices
and vectors containing different summary statistics as well as the correlation
matrix as in \link{baboon.parms_list}. By setting the option `univariate`
to `TRUE`, multiple `ANOVA`s can be run on each parameter independently.
}
\examples{
# x is a data frame with separate correlation matrix
multivariate(baboon.parms_df, R.res = baboon.parms_R)
# x is a list with the correlation matrix included
multivariate(baboon.parms_list, univariate = TRUE)
# reproduces results from Konigsberg (1991)
multivariate(baboon.parms_df, R.res = baboon.parms_R)[3, ]
multivariate(baboon.parms_df, R.res = baboon.parms_R, interact_manova = FALSE)
}
\seealso{
\link{baboon.parms_df}
}
