% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{rRDTS}
\alias{rRDTS}
\title{Function to generate random variates of RDTS distribution.}
\usage{
rRDTS(
  n,
  alpha = NULL,
  delta = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  methodR = "SR",
  k = 10000
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{delta}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{methodR}{A String. Only "SR" works currently.}

\item{k}{integer: the level of truncation, if \code{methodR == "SR"}. 10000
by default.}
}
\value{
Generates \code{n} random numbers of the RDTS distribution.
}
\description{
Generates \code{n} random numbers distributed according to the rapidly
decreasing tempered stable (CTS) distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
"SR" stands for a truncated infinite shot noise series representation. Kim et
al. (2010) showed how to simulate random variates with SR-method for the RDTS
distribution. For more details, see references.

It is recommended to check the generated random numbers once for each
distribution using the density function. If the random numbers are shifted,
e.g. for the method "SR", it may be worthwhile to increase k.
}
\examples{
rCTS(10,0.5,1,1,1,1,1,NULL,"SR",10)
rCTS(10,0.5,1,1,1,1,1,NULL,"aAR")

}
\references{
Kim, Young Shi & Rachev, Svetlozar T. & Leonardo Bianchi, Michele & Fabozzi,
Frank J. (2010), 'Tempered stable and tempered infinitely divisible GARCH
models' \doi{10.1016/j.jbankfin.2010.01.015}
}
