% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{dKRTS}
\alias{dKRTS}
\title{Density Function of the Kim-Rachev tempered stable distribution}
\usage{
dKRTS(
  x,
  alpha = NULL,
  kp = NULL,
  km = NULL,
  rp = NULL,
  rm = NULL,
  pp = NULL,
  pm = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -20,
  b = 20,
  nf = 256
)
}
\arguments{
\item{x}{A numeric vector of positive quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{kp, km, rp, rm}{Parameter of KR-distribution. A real number \code{>0}.}

\item{pp, pm}{Parameter of KR-distribution. A real number \code{>-alpha}.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{Algorithm for numerical evaluation. Here you can only
choose \code{"FFT"}.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size. 256 by default.}
}
\value{
The CF of the the Kim-Rachev tempered stable distribution.
}
\description{
The probability density function (PDF) of the Kim-Rachev tempered stable
distributions is not available in closed form.
Relies on fast Fourier transform (FFT) applied to the characteristic
function.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, kp, km,
rp, rm, pp. pm, mu)}. Either provide the parameters individually OR
provide \code{theta}.

For examples, compare with \code{\link[=dCTS]{dCTS()}}.
}
