\name{get.tree}
\alias{get.tree}
\title{
  Method for getting appointed trees from a TWIX-multitree.
}
\description{This function extracts a single tree from a \code{TWIX}
    object.}
\usage{
  get.tree(m.tr, n = 1, id = NULL) 
}
\arguments{
  \item{m.tr}{an object of class \code{TWIX} generated by
    \code{TWIX}}
  \item{n}{integer. Which tree must be extracted?}
  \item{id}{a vector of integers. ID of the tree.}
}
\seealso{
  \code{\link{TWIX}},  \code{\link{predict.TWIX}}
}
\examples{
    data(olives)
    TreeFR <- TWIX(Area~.,data=olives,topN=c(2,1),method="local")
    TreeSG <- get.tree(TreeFR,n=1)
    TreeSG
}
\keyword{tree}
