\name{plot.TWIX}
\alias{plot.TWIX}
\alias{plot.bootTWIX}
\title{
  Plotting method for TWIX objects
}
\description{
  Plot an \code{TWIX} or \code{bootTWIX} object generated by
                    TWIX  or bootTWIX function(s).}
\usage{
\method{plot}{TWIX}(x, sq = 1:length(x$trees), type = "deviance",
		i.plot = FALSE, size = 3, freq = TRUE,
		breaks = "Sturges", pch = par("pch"), ...)
}
\arguments{
  \item{x}{an object of class \code{TWIX}.}
  \item{sq}{Integer vector giving the number of trees to be plotted.}
  \item{type}{one of \code{"deviance"}, \code{"ccr"},\code{"d&c"}.}
  \item{i.plot}{logical. If \code{TRUE}, iplot will be used (library iplot will be required).}
  \item{size}{value for largest circle (\code{cex}).}
  \item{freq}{logical. Should the frequence or density be plotted.}
  \item{breaks}{see histogram.}
  \item{pch}{a vector of plotting characters or symbols.}
  \item{...}{graphical parameters can be given as arguments to 'plot'.}
}
\details{
    If \code{type = "deviance"}:\cr
    the training deviance vs. test deviance will be plotted.\cr
    If \code{type = "ccr"}:\cr
    the correct classification rate(CCR) for training data vs. the CCR for test data.\cr
    If \code{type = "d&c"}:\cr
    the deviance vs. CCR for test data.
}
\seealso{
  \code{\link{TWIX}},  \code{\link{get.tree}}
}
\examples{
    data(olives)

    ### train and test data
    set.seed(123)
    i <- sample(572,150)
    ic <- setdiff(1:572,i)
    training <- olives[ic,]
    test <- olives[i,]

    TM1 <- TWIX(Region~.,data=training[,1:9],test.data=test,
		topN=c(5,3),method="local")
    plot(TM1)
    plot(TM1,type="ccr")
    plot(TM1,type="d&c")

}
\keyword{tree}
