% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TTS.R
\name{TTS}
\alias{TTS}
\title{Time-Temperature Superposition (TTS) analysis}
\usage{
TTS(x, reference.temperature = 150, n = 100, nB = 100,
  method = c("derived", "WLF", "Arrhenius"))
}
\arguments{
\item{x}{Matrix or data frame composed of three columns: a numeric column
vector with the experimental frequencies (in logarithmic scale, base-ten),
the modulus (E' or G') base-ten logarithm vector and, finally the
corresponding temperatures vector.}

\item{reference.temperature}{Value of the selected reference temperatura at
which the Master Curve of modulus will be obtained, the default value of
temperature is 150.}

\item{n}{Number of partitions in the frequency domain in order to fit the
B-spline basis. The default value is 100.}

\item{nB}{Number of bootstrap replicates to estimate confidence intervals
of master curve fitting. The default is 100.}

\item{method}{A string vector composed of one of the following options:
"derived" (by default), "WLF" and "Arrhenius".}
}
\value{
The function returns a list composed of the following outputs:

\item{data}{Input experimental data.} \item{aT}{Numerical vector of
horizontal shifts between the modulus curves.} \item{bT}{Numerical vector
of vertical shifts between the modulus curves.} \item{TTS.data}{Master
Curve Data frame defined by three columns: log10frequency, log10module and
temperature.} \item{ref.temp}{Reference temperature value.}
\item{TTS.gam}{Data frame of the Generalized Additive Model with B-splines
(GAM) estimate of the Master Curve. It contains two columns: frequency and
Prediction.} \item{I.lower}{Lower limit of bootstrap confidence interval
corresponding to the estimated B-splines Master Curve.}
\item{I.upper}{Upper limit of bootstrap confidence interval corresponding
to the estimated B-splines Master Curve.} \item{residuals}{Residuals
corresponding to the GAM with B-splines Master Curve fitting.}
}
\description{
The Master Curve at a specific temperature is estimated using
Time-Temperature Superposition (TTS) procedures.  The Master Curve means
the variation of a specific viscoelastic property of the selected material
depending on time or frequency. TTS procedures provide the viscoelastic
property variation at the selected temperature in a wider interval of time
or frequency than in the experimental case. The Master Curve is estimated
for each selected reference temperaure using TTS procedures. Three TTS
methodologies are implemented in this package: the two wider used methods,
Arrhenius based methods and WLF, and the newer methodology based on
derivatives procedure. The Master Curve is smoothed by B-splines basis.
}
\details{
El New method for estimating shift factors in time-temperatura
superposition models (Naya et al., 2013) opens the possibility to perform
the TTS function. The horizontal and vertical shifts are calculated.
Namely, the different methods are differenciated due to the expression for
estimating the horizontal shifts, aT. The "derivated" method is based on
the application of horizontal shifts to the moduli derivatives (depending
on the frequency) and thus obtaining the Master Curve at the selected
temperature:\cr

(dE')/dx(x+aT) -> (dE')/dx(x)\cr

WLF method is defined by the parametric expression:\cr

Log10(aT)=-C1*(T-To)/(C2+(T-To))\cr

Where C1 and C2 are constants to be estimated, T is the temperature and To
the reference temperature.\cr

Arrhenius method is defined by the parametric expression:\cr

Log10(aT)=Ea*((1/T)-(1/To))*log10(2.718282)/R

Where Ea is the activation energy, R = 8.314 J/mol is the universal gas
constant, T is the absolute temperature (Kelvin degrees), and To the
reference temperature (Celsius degrees).\cr

The vertical shifts, bT, are calculated taking into account the vertical
distance between the moduli curves.
}
\examples{
## Polycarbonate dataset
data(PC)
x <- PC
## TTS function applied to polycarbonate.
derive <- TTS(x,reference.temperature=150, method=c("derived","WLF",
              "Arrhenius"))
names(derive)
##[1] "data"    "aT"   "bT"  "TTS.data"  "ref.temp"  "TTS.gam"
##[7] "I.lower"   "I.upper"   "residuals"
## Horizontal shifts vector of modulus versus frequency curves.
derive$aT
## Reference temperature
derive$ref.temp
}
\author{
Antonio Meneses \email{antoniomenesesfreire@hotmail.com}, Salvador
Naya \email{salva@udc.es} and Javier Tarrio-Saavedra
\email{jtarrio@udc.es}
}
\references{
Naya, S., Meneses A., Tarrio-Saavedra, J., Artiaga R.,
Lopez-Beceiro, J. and Gracia-Fernandez C. (2013) New method for estimating
shift factors in time-temperatura superposition models. Journal of Thermal
Analysis and Calorimetry. ISSN 1388-6150. DOI 10.1007/s10973-013-3193-1.\cr

Williams, M. L. (1964) Structural analysis of Viscoelastic materials. AIAA
Journal, 785-808.\cr

Artiaga R., Garcia A. Fundamentals of DMA. In: 'Thermal analysis.
Fundamentals and applications to material characterization' (ed.: Artiaga
R.) Publicaciones de la Universidade da Coruna, A Coruna, Spain, 183-206
(2005).\cr
}
\keyword{TTS}

