\name{zip}
\alias{zip}
\alias{TSconnect,zipDriver,character-method}
\alias{TSget,character,TSzipConnection-method}
\alias{TSdates,character,TSzipConnection-method}
\alias{TSdescription,character,TSzipConnection-method}
\alias{TSdoc,character,TSzipConnection-method}
\alias{TSlabel,character,TSzipConnection-method}
\alias{TSsource,character,TSzipConnection-method}

\alias{dbDisconnect,TSzipConnection-method}

\alias{zipDriver-class}
\alias{TSzipConnection-class}

\title{Methods for TSdbi Generics to Connect to zipped csv Files}
\description{Get a time series (matrix) from a zipped csv file (at a url).}
\usage{
     zip() 
    \S4method{TSget}{character,TSzipConnection}(
	serIDs, con, TSrepresentation=options()$TSrepresentation,
        tf=NULL, start=tfstart(tf), end=tfend(tf),
        names=NULL, quote=con@suffix, ...)
    \S4method{TSconnect}{zipDriver,character}(drv, dbname, 
                suffix=c("Open","High","Low","Close","Volume","OI"), ...)
    \S4method{TSdates}{character,TSzipConnection}(
	serIDs, con, vintage=NULL, panel=NULL, ... )  
    \S4method{TSdescription}{character,TSzipConnection}(x, con, ... )  
    \S4method{TSdoc}{character,TSzipConnection}(x, con, ... )  
    \S4method{TSlabel}{character,TSzipConnection}(x, con, ... )  
    \S4method{TSsource}{character,TSzipConnection}(x, con, ... )  

    \S4method{dbDisconnect}{TSzipConnection}(conn,...)
}
\arguments{
    \item{con}{a database connection object.}
    \item{conn}{a database connection object.}
    \item{serIDs}{identifiers for series on the database
        (name of the zip file less ''.zip'').}
    \item{vintage}{character string indicating vintage of the series on the 
        database (not supported by this database).}
    \item{panel}{character string indicating panel of the series on the 
        database (not supported by this database).}
    \item{x}{time series data(TSput), or 
      identifiers for series on the database (TSdoc and TSdescription).}
    \item{names}{optional character vector to use for series names in the R
    object.}
    \item{drv}{a database driver object.}
    \item{dbname}{a character string indicating the name of a database.}
    \item{tf}{time frame for trimming data, passed to tfwindow.}
    \item{start}{time frame for trimming data, passed to tfwindow.}
    \item{end}{time frame for trimming data, passed to tfwindow.}
    \item{TSrepresentation}{time representation for returned series. 
          (See \code{TSget} in package \pkg{TSdbi}.)}
    \item{suffix}{A vector of strings indicating names of the columns if the 
          zipped file has more than one series (see Details).}
    \item{quote}{A vector of strings, as in suffix, indicating series that
           should be returned in the result(see Details).}
   \item{...}{Arguments currently unused.}
}
\value{Depends.}
\details{
These functions interface to zip (\code{.zip}) files. \code{TSget} 
is a wrapper to \code{read.csv} to provide an interface that is consistent 
with \pkg{TSdbi}. The \pkg{TSdbi} function argument \code{serId} is passed as the series to return,
\code{dbname} indicates the location of zip files (a url or directory). 

\pkg{TSzip} does not support writing data to the source.

If the zip files in a \code{dbname} location contain more than one series then 
\code{suffix} should be a vector of strings indicating names of the columns in
the zipped files. (If different files contain different columns then a
\code{con} will have to be specified for each different kind of returned file.)
In \code{TSget}, \code{quote} should be a vector of strings, a subset of
\code{suffix}, indicating series that should be returned in the result. The default returns all series. In the matrix of series returned, the series names will be generated by appending suffix onto the name of the base name of the
zip file.

The classes \code{zipDriver} and \code{TSzipConnection} extend classes
\code{DBIDriver} and  \code{DBIConnection} in the DBI package.

See the package vignette for additional examples 
and \code{TSget} in \pkg{TSdbi} for more details.
}

\seealso{ 
\code{\link[TSdbi]{TSdates}},
\code{\link[TSdbi]{TSget}},
\code{\link[tframe]{tfwindow}}
}
\examples{
  require("tfplot")
  # data from http://pitrading.com/
  # par(ask=TRUE) # to pause between pages
  con <- TSconnect("zip", dbname="http://pitrading.com/free_eod_data")
  x <- TSget("EURUSD", con)
  tfplot(x, graphs.per.page=3)

  z <- TSget(c("AD", "CD"), con, quote="Close")
  tfplot(z, start="2007-01-01", Title=
   "Futures, Australian and Canadian Dollar Continuous Contract at Close",
    graphs.per.page=3)
 }
\keyword{ts}
