% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_based_repr.R
\name{repr_exp}
\alias{repr_exp}
\title{Exponential smoothing seasonal coefficients as representation}
\usage{
repr_exp(x, freq, alpha = TRUE, gamma = TRUE)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{freq}{the frequency of the time series}

\item{alpha}{the smoothing factor (default is TRUE - automatic determination of smoothing factor), or number between 0 to 1}

\item{gamma}{the seasonal smoothing factor (default is TRUE - automatic determination of seasonal smoothing factor), or number between 0 to 1}
}
\value{
the numeric vector of seasonal coefficients
}
\description{
The \code{repr_exp} computes exponential smoothing seasonal coefficients.
}
\details{
This function extracts exponential smoothing seasonal coefficients and uses them as time series representation.
You can set smoothing factors (\code{alpha, gamma}) manually, but recommended is automatic method (set to \code{TRUE}).
The trend component is not included in computations.
}
\examples{
repr_exp(rnorm(96), freq = 24)

}
\references{
Laurinec P, Lucka M (2016)
Comparison of representations of time series for clustering smart meter data.
In: Lecture Notes in Engineering and Computer Science: Proceedings of The World Congress on Engineering and Computer Science 2016, pp 458-463

Laurinec P, Loderer M, Vrablecova P, Lucka M, Rozinajova V, Ezzeddine AB (2016)
Adaptive time series forecasting of energy consumption using optimized cluster analysis.
In: Data Mining Workshops (ICDMW), 2016 IEEE 16th International Conference on, IEEE, pp 398-405
}
\seealso{
\code{\link[TSrepr]{repr_lm}, \link[TSrepr]{repr_gam}, \link[TSrepr]{repr_seas_profile},
\link[stats]{HoltWinters}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
