% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowing.R
\name{repr_windowing}
\alias{repr_windowing}
\title{Windowing of time series}
\usage{
repr_windowing(x, win_size, func = NULL, args = NULL)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{win_size}{the length of the window}

\item{func}{the function for representation computation. For example \code{repr_feaclip} or \code{repr_trend}.}

\item{args}{the list of additional arguments to the func (representation computation function). The args list must be named.}
}
\value{
the numeric vector
}
\description{
The \code{repr_windowing} computes representations from windows of a vector.
}
\details{
This function applies specified representation method (function) to every non-overlapping window (subsequence, piece) of a time series.
}
\examples{
# func without arguments
repr_windowing(rnorm(48), win_size = 24, func = repr_feaclip)

# func with arguments
repr_windowing(rnorm(48), win_size = 24, func = repr_featrend,
 args = list(func = maxC, order = 2, pieces = 2))

}
\seealso{
\code{\link[TSrepr]{repr_paa}, \link[TSrepr]{repr_matrix}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
