% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADDline.R
\name{ADDline}
\alias{ADDline}
\title{‘ADDline’}
\usage{
ADDline(ARIMAmodel = NULL, XREG = NULL, TS = NULL, linetype = "TS",
  Name = NULL)
}
\arguments{
\item{ARIMAmodel}{ARIMA model created by function \code{auto.arima()}}

\item{XREG}{if using ARIMAX model, put in the regularized X matrix}

\item{TS}{data created by \code{ts()} function}

\item{linetype}{"TS" for time series data, "ARIMA" for ARIMA(X) predicted data}

\item{Name}{title for this line}
}
\value{
a list contains 4 elements:
\item{X}{data put in parameter "x" of plot_ly function}
\item{TEXT}{rename the lable of variable X}
\item{Y}{data put in parameter "y" of plot_ly function}
\item{NAME}{title of the new line}
}
\description{
create a list of line data based on ARIMA(X) predicted result or ts function result(i.e. time series data)
}
\details{
This function \code{ADDline} is used to conduct a data transformation. It can take in original time-series data generated
by function \code{ts} or fitted ARIMA(X) model generated by function \code{auto.arima} then take out four elements from
those result to create a list which contains content that can be put in function \code{add_lines} or \code{add_trace}.
So that we could add new lines in our plotly plot more easily.
}
\examples{
require(forecast)
require(zoo)
require(plotly)

#Firstly create a base plotly plot
Tempplot<-TSplot(48,modArima_train,as.matrix(X_test),title_size = 8,
ts_original = "Original time series",ts_forecast = "Predicted time series")

# Generate a new line with ADDline function
newline<-ADDline(TS = MCSI_Data_monthAvg_ts_Y_test,linetype = "TS",Name = "Original Result")

## Put the new line into our plot
Tempplot\%>\%
  add_lines(x=newline$X,text=newline$TEXT,y=newline$Y,name=newline$NAME,line=list(color="grey"))

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
