% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSS_RESTREND.R
\name{TSSRESTREND}
\alias{TSSRESTREND}
\title{Time Series Segmentation of Residual Trends (MAIN FUNCTION)}
\usage{
TSSRESTREND(
  CTSR.VI,
  ACP.table = FALSE,
  ACT.table = NULL,
  CTSR.RF = FALSE,
  CTSR.TM = NULL,
  anu.VI = FALSE,
  acu.RF = FALSE,
  acu.TM = NULL,
  VI.index = FALSE,
  rf.b4 = FALSE,
  rf.af = FALSE,
  sig = 0.05,
  season = "none",
  exclude = 0,
  allow.negative = FALSE,
  allowneg.retest = FALSE,
  h = 0.15,
  retnonsig = FALSE
)
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{ACP.table}{A table of every combination of offset period and accumulation period.for precipitation
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{ACT.table}{A table of every combination of offset period and accumulation period.for temperature
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{CTSR.RF}{Complete Time Series of Rainfall. An object of class 'ts' object without NA's
and be the same length and cover the same time range as CTSR.VI.
If ACP.table is provided, CTSR.RF will be automitaclly calculated using the
\code{\link{ACP.calculator}}}

\item{CTSR.TM}{Complete Time Series of temperature. An object of class 'ts' object without NA's
and be the same length and cover the same time range as CTSR.VI.  Default (CTSR.TM=NULL).
If ACT.table is provided, CTSR.RF will be automitaclly calculated using the
\code{\link{ACP.calculator}}}

\item{anu.VI}{The annual (Growing season) max VI. Must be a object of class \code{'ts'} without NA's.
if anu.VI=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{acu.RF}{The optimal accumulated rainfall for anu.VI. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.VI. if anu.RF=FALSE, it will be
calculated from ACP.table usingthe \code{\link{AnnualClim.Cal}}}

\item{acu.TM}{The optimal accumulated rainfall for anu.TM. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.TM. if anu.TM=FALSE, it will be
calculated from ACT.table usingthe \code{\link{AnnualClim.Cal}}}

\item{VI.index}{the index of the CTSR.VI ts that the anu.VI values occur at. Must be the same length
as anu.VI. NOTE. R indexs from 1 rather than 0.
if VI.index=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{rf.b4}{If a breakpoint in the VPR is detected this is the optimial accumulated rainfall before
the breakpoint. must be the same length as the anu.VI. If ACP.table is provided it will
be generated using \code{\link{AnnualClim.Cal}}}

\item{rf.af}{If a breakpoint in the VPR is detected this is the optimial accumulated rainfall after
the breakpoint. must be the same length as the anu.VI. If ACP.table is provided it will
be generated using \code{\link{AnnualClim.Cal}}}

\item{sig}{Significance of all the functions. defualt sig=0.05}

\item{season}{See \code{\link[bfast]{bfast}}. This season value only applies to bfast done using the CTS
VPR. if a non VPR adjusted BFAST is performed.a harmonic season is used.}

\item{exclude}{A numberic vector containg months excluded from breakpoint detection.  This was included to
allow sensor transitions to be masked.}

\item{allow.negative}{If true, will not preference positive slope in either CTSR or VI calculations. default=FALSE is set
because negative associations between rainfall and vegetation in water limited ecosystems is unexpected
If temperature data is included then this paramter is forced to TRUE.}

\item{allowneg.retest}{default=FALSE
If temperature data is provided but found to not be significant then a retest is performed.
This paramter is to allow negative on re-test.}

\item{h}{See \code{\link[bfast]{bfast}}, The.minimal segment size between potentially detected breaks in the trend model
given as fraction relative to the sample size (i.e. the minimal number of observations in each segment
divided by the total length of the timeseries. Default h = 0.15.}

\item{retnonsig}{Bool. New in v0.3.0. Allows TSSRESTREND to return change estimates of values that filed the sig component in the residual analysis.
defualt FALSE will give the same result as eralier versions.}
}
\value{
An object of class \code{'TSSRESTREND'} is a list with the following elements:
\describe{
  \item{\bold{\emph{summary}}}{
   \describe{
   \item{Method}{The method used to determine total change. (\emph{RESTREND} see \code{\link{RESTREND}},
     \emph{segmented.RESTREND} see \code{\link{seg.RESTREND}}, \emph{segmented.VPR} see
     \code{\link{seg.VPR}})}
   \item{Total.Change}{The total significant change. Residual.Change + VPR.HeightChange. }
   \item{Residual.Change}{The change in the VPR Residuals over the time period}
   \item{VPR.HeightChange}{The change in VI at mean rainfall for a "ts" with a significant
     breakpoint in the VPR}
   \item{model.p}{p value of the regression model fitted to the VPR. See \code{\link[stats]{lm}}}
   \item{residual.p}{p value of the regression model fitted to the VPR Residuals. See \code{\link[stats]{lm}}}
   \item{VPRbreak.p}{the p value associated with the break height. See \code{\link[stats]{lm}}}
   \item{bp.year}{The Year of the most significant breakpoint}
   }}
  \item{\bold{\emph{ts.data}}}{The Time series used in analysis. See Arguments for description
   \itemize{
     \item CTSR.VI
     \item CTSR.RF
     \item anu.VI
     \item VI.index
     \item acu.RF
     \item StdVar.RF see \code{\link{seg.VPR}})}
     }
  \item{\bold{\emph{ols.summary}}}{
     \describe{
       \item{chow.summary}{summary of the most significant breakpoint. }
       \item{chow.ind}{Summary of every detected breakpoint}
       \item{OLS.table}{A matrix containing the coefficents for the CTS.fit, VPR.fit, RESTREND.fit and segVPR.fit}
       }}
   \item{\bold{\emph{TSSRmodels}}}{
   models of class "lm" \code{\link[stats]{lm}} and class "bfast" \code{\link[bfast]{bfast}} generated.}
   }
}
\description{
Time Series Segmented Residual Trend (TSS.RESTREND) methodology.Takes in a complete monthly
time series of a VI and its corrosponding precipitation (and temperature). It then looks looks
for breakpoints using the BFAST function. The significance of the breakpoin in the residuals
and the VPR is assessed using a Chow test, then, the total time series change is calculated.
}
\note{
if ACP.table = FALSE, CTSR.RF and acu.RF must be provided as well as
       rf.b4 and rf.af for \code{'ts'} with a breakpoint in the VPR.
}
\examples{
\dontrun{
#To get the latest version of the package (Still in development)
install.packages("devtools")
library("devtools")
install_github("ArdenB/TSSRESTREND", subdir="TSS.RESTREND")
library(TSS.RESTREND)
#Find the path of the rabbitRF.csv dataset, read it in and turn it into a time series
rf.path<- system.file("extdata", "rabbitRF.csv", package = "TSS.RESTREND", mustWork = TRUE)
in.RF <- read.csv(rf.path)
rf.data <- ts(in.RF, end=c(2013,12), frequency = 12)

#Find the path of the rabbitVI.csv dataset and read it in
vi.path <- system.file("extdata", "rabbitVI.csv", package = "TSS.RESTREND", mustWork = TRUE)
in.VI <- read.csv(vi.path)
CTSR.VI <- ts(in.VI, start=c(1982, 1), end=c(2013,12), frequency = 12)

#Define the max accumuulation period
max.acp <- 12
#Define the max offset period
max.osp <- 4
#Create a table of every possible precipitation value given the max.acp and max.osp
ACP.table <- climate.accumulator(CTSR.VI, rf.data, max.acp, max.osp)
results <- TSSRESTREND(CTSR.VI, ACP.table)
print(results)
plot(results, verbose=TRUE)
}

}
\seealso{
\itemize{
   \item \code{\link{plot.TSSRESTREND}}
   \item \code{\link{print.TSSRESTREND}}
   }
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}
