% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LT.r
\name{LogT}
\alias{LogT}
\alias{LogT.rev}
\title{Logarithmic Transformation}
\usage{
LogT(x, base = exp(1))

LogT.rev(x, base = exp(1))
}
\arguments{
\item{x}{A numeric vector or univariate time series of class \code{ts}.}

\item{base}{A numeric value corresponding to the base with respect 
to which logarithms are computed. Default: \code{exp(1)}.}
}
\value{
A vector of the same length as x containing the transformed values.
}
\description{
The \code{LogT()} function returns a logarithmic transformation of the
provided time series. A natural log is returned by default. 
\code{LogT.rev()} reverses the transformation.
}
\examples{

data(NN5.A)
LogT(NN5.A[,10])

}
\references{
R. H. Shumway, D. S. Stoffer, Time Series Analysis and Its
Applications: With R Examples, Springer, New York, NY, 4 edition, 2017.
}
\seealso{
Other transformation methods: 
\code{\link{Diff}()},
\code{\link{WaveletT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{outliers_bp}()},
\code{\link{pct}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{logarithm}
\keyword{series}
\keyword{time}
\keyword{transform}
