% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCorrect.R
\name{KFprocess}
\alias{KFprocess}
\title{Enhanced Kalman filter to reduce the noise of raw data}
\usage{
KFprocess(x, manual = NULL, ...)
}
\arguments{
\item{x}{A data frame with \code{\link[VBTree:VBTree-package]{VBTree}} style. Pay attention, all factors
in column names should be separated by "-" symbol, and factors for temperatures and strain rates should be
saved in pure numeric style.}

\item{manual}{An integer vector with the length of 3 where the 1st element denotes the layer for Stress and
Strain, the 2nd and 3rd elements represent the levels for Strain and Stress, respectively. The default setting is
NULL, which can call the function \code{\link[TPMplt:lyIDdetector]{lyIDdetector}} for automatic completion.}

\item{...}{The arguments dV and dW passed on to \code{\link[dlm:dlmModPoly]{dlmModPoly}} in the function
\code{\link[dlm:dlmSmooth]{dlmSmooth}}.}
}
\value{
A data frame with the identical shape as input data, but with the smoothed stress values.
}
\description{
Kalman filter reducing the noise in raw data if it is necessary.
}
\examples{
\donttest{
# raw data without smoothing:
SSplots(TPMdata, 2, mfrow=c(2, 2))

# Smoothing to reduce the noise:
KFdt <-KFprocess(TPMdata, dV = 0.3, dW = 0.006)
SSplots(KFdt, 2, mfrow=c(2, 2))
}
}
\seealso{
\code{\link[VBTree:VBTree-package]{VBTree}}, \code{\link[dlm:dlmModPoly]{dlmModPoly}}, \code{\link[dlm:dlmSmooth]{dlmSmooth}}
}
\keyword{KFprocess}
