% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPLS.R
\name{TPLS}
\alias{TPLS}
\title{Fit a TPLS model to data}
\usage{
TPLS(X, Y, NComp = 50, W = 0, nmc = 0)
}
\arguments{
\item{X}{n-by-v data matrix of real numbers. Rows correspond to observations (trials) and columns to variables (e.g., fMRI voxels).}

\item{Y}{n-by-1 Vector of real numbers. Can be binary (0/1) for classification model, or can be continuous.}

\item{NComp}{Maximum number of partial least squares component you want to use. Default is 50, and this is on the safe side for fMRI.}

\item{W}{n-by-1 vector of positive observation weights.}

\item{nmc}{A switch to skip mean-centering. Default is off (0). Only turn it on (1) when the data is already mean-centered and you want to save memory space by not creating another copy of the data for mean-centering.}
}
\value{
A TPLS object that contains the following attributes. Most of the time, you won't need to access the attributes.
\itemize{
    \item \code{NComp}: The number of components you specified in the input
    \item \code{W}: Normalized version of the observation weights (i.e., they sum to 1)
    \item \code{MtrainX}: Column mean of X. Weighted mean if W is given.
    \item \code{MtrainY}: Mean of Y. Weighted mean if W is given.
    \item \code{scoreCorr}: Correlation between Y and each PLS component. Weighted correlation if W is given.
    \item \code{pctVar}: Proportion of variance of Y that each component explains.
    \item \code{betamap}: v-by-NComp matrix of TPLS coefficients for each of the v variables, provided at each model with NComp components.
    \item \code{threshmap} : v-by-NComp matrix of TPLS threshold values (0~1) for each of the v variables, provided at each model with NComp components.
}
}
\description{
Fit a TPLS model to data
}
\examples{
# Fit example TPLS data with a TPLS model
# Load example data (included with package).
X = TPLSdat$X
Y = TPLSdat$Y

# Fit the model, with default options (50 components, no observation weights)
TPLSmdl <- TPLS(X,Y)

# Make in-sample prediction at threshold of 0.5 and at all possible components
pred <- TPLSpredict(TPLSmdl,1:50,0.5,X)

# Look at the correlation between prediction and Y.
# This is in-sample prediction. Ergo, the model with most components will have the highest
# predictive correlation. In practice, you should choose the number of components and
# threshold using cross-validation. See example for TPLS_cv
cor(Y,pred)

# Extract the predictor for a model with 25 PLS components and threshold at 0.7 (just cuz)
betamap <- makePredictor(TPLSmdl,25,0.5)

# This is the intercept
betamap$bias

# These are the coefficients for the original variables
betamap$betamap
}
