% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_htest.R
\name{simple_htest}
\alias{simple_htest}
\alias{simple_htest.default}
\alias{simple_htest.formula}
\title{One, two, and paired samples hypothesis tests}
\usage{
simple_htest(
  x,
  ...,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = NULL,
  alpha = 0.05
)

\method{simple_htest}{default}(
  x,
  y = NULL,
  test = c("t.test", "wilcox.test", "brunner_munzel"),
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  mu = NULL,
  alpha = 0.05,
  ...
)

\method{simple_htest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{mu}{a number specifying an optional parameter used to form the null hypothesis. See ‘Details’.}

\item{alpha}{alpha level (default = 0.05)}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{test}{a character string specifying what type of hypothesis test to use. Options are limited to "wilcox.test", "t.test", or "brunner_munzel". You can specify just the initial letter.}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
A list with class \code{"htest"} containing the following components:
\itemize{
\item statistic: the value of the t-statistic.
\item parameter: the degrees of freedom for the t-statistic.
\item p.value: the p-value for the test.
\item conf.int: a confidence interval for the mean appropriate to the specified alternative hypothesis.
\item estimate: the estimated mean or difference in means depending on whether it was a one-sample test or a two-sample test.
\item null.value: the specified hypothesized value of the mean or mean difference. May be 2 values.
\item stderr: the standard error of the mean (difference), used as denominator in the t-statistic formula.
\item alternative: a character string describing the alternative hypothesis.
\item method: a character string indicating what type of t-test was performed.
\item data.name: a character string giving the name(s) of the data.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Performs one or two sample t-tests or Wilcoxon-Mann-Whitney rank-based tests with expanded options compared to \link{t.test}, \link{brunner_munzel}, or \link{wilcox.test}.
}
\details{
The type of test, t-test/Wilcoxon-Mann-Whitney/Brunner-Munzel, can be selected with the \code{"test"} argument.

\code{alternative = "greater"} is the alternative that x is larger than y (on average).
If \code{alternative = "equivalence"} then the alternative is that the difference between x and y is between the two null values \code{mu}..
If \code{alternative = "minimal.effect"} then the alternative is that the difference between x and y is less than the lowest null value or greater than the highest.

For more details on each possible test (\link{brunner_munzel}, \link[stats:t.test]{stats::t.test}, or \link[stats:wilcox.test]{stats::wilcox.test}), please read their individual documentation.
}
\examples{
data(mtcars)
simple_htest(mpg ~ am,
data = mtcars,
alternative = "e",
mu = 3)
}
\seealso{
Other TOST: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_TOST}()},
\code{\link{t_TOST}()},
\code{\link{tsum_TOST}()},
\code{\link{wilcox_TOST}()}

Other htest: 
\code{\link{as_htest}()},
\code{\link{htest-helpers}}
}
\concept{TOST}
\concept{htest}
