% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_correlations.R
\name{power_z_cor}
\alias{power_z_cor}
\alias{powerTOSTr}
\title{Power Calculations for Correlations}
\usage{
power_z_cor(
  n = NULL,
  rho = NULL,
  power = NULL,
  null = 0,
  alpha = NULL,
  alternative = c("two.sided", "less", "greater", "equivalence")
)

powerTOSTr(alpha, statistical_power, N, low_eqbound_r, high_eqbound_r)
}
\arguments{
\item{n}{number of observations.}

\item{rho}{true correlation value (alternative hypothesis).}

\item{power}{statistical power (1-beta).}

\item{null}{the null hypothesis value.}

\item{alpha}{a priori alpha-level (i.e., significance level).}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", or "equivalence" (TOST). You can specify just the initial letter.}

\item{statistical_power}{Deprecated. desired power (e.g., 0.8)}

\item{N}{Deprecated. number of pairs (e.g., 96)}

\item{low_eqbound_r}{Deprecated. lower equivalence bounds (e.g., -0.3) expressed in a correlation effect size}

\item{high_eqbound_r}{Deprecated. upper equivalence bounds (e.g., 0.3) expressed in a correlation effect size}
}
\value{
An object of the class power.htest.
This will include the sample size (n), power, beta (1-power), alpha (significance level), null value(s), alternative hypothesis, and a text string detailing the method.

\code{powerTOSTr} has been replaced by the \code{power_z_cor} function. The function is only retained for historical purposes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Calculates the approximate power for a z-test based on a Pearson product-moment correlation.
}
\examples{
## Sample size for alpha = 0.05, 90\% power, equivalence bounds of
## r = -0.1 and r = 0.1, assuming true effect = 0
#powerTOSTr(alpha=0.05, statistical_power=0.9, low_eqbound_r=-0.1, high_eqbound_r=0.1)
power_z_cor(alternative = "equivalence", alpha = .05, null = .1, power = .9, rho = 0)

## Sample size for alpha = 0.05, N=536, equivalence bounds of
## r = -0.1 and r = 0.1, assuming true effect = 0
#powerTOSTr(alpha=0.05, N=536, low_eqbound_r=-0.1, high_eqbound_r=0.1)
power_z_cor(alternative = "equivalence", alpha = .05, null = .1, n = 536, rho = 0)

## Equivalence bounds for alpha = 0.05, N=536, statistical power of
## 0.9, assuming true effect = 0
#powerTOSTr(alpha=0.05, N=536, statistical_power=0.9)

}
\seealso{
Other Correlations: 
\code{\link{boot_cor_test}()},
\code{\link{corsum_test}()},
\code{\link{plot_cor}()},
\code{\link{z_cor_test}()}

Other power: 
\code{\link{power_eq_f}()},
\code{\link{power_t_TOST}()}
}
\concept{Correlations}
\concept{power}
