% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTanova.R
\name{power_eq_f}
\alias{power_eq_f}
\title{Power analysis for TOST for an F-test}
\usage{
power_eq_f(alpha = 0.05, df1, df2, eqbound)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{df1}{Degrees of freedom for the numerator}

\item{df2}{Degrees of freedom for the denominator}

\item{eqbound}{Equivalence bound for the partial eta-squared}
}
\value{
Object of class '"power.htest"
}
\description{
Power analysis for TOST for an F-test
}
\section{References}{

Campbell, H., & Lakens, D. (2021). Can we disregard the whole model? Omnibus non‐inferiority testing for R2 in multi‐variable linear regression and in ANOVA. British Journal of Mathematical and Statistical Psychology, 74(1), 64-89. doi: 10.1111/bmsp.12201
}

\examples{
## Statistical power for alpha = 0.05, 3 groups, n = 80 per group, equivalence bound of
## partial eta squared = 0.01, assuming true effect = 0.
## df1 = number of groups - 1 = 3 - 1 = 2.
## df2 = Total N - number of groups = 240 - 3 = 237.
# powerTOST_f(alpha=0.05, df1=3, df2 = 237, eqbound = 0.01)
}
\seealso{
Other power: 
\code{\link{power_t_TOST}()}
}
\concept{power}
