% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatosttwo.h.R
\name{dataTOSTtwo}
\alias{dataTOSTtwo}
\title{TOST Independent Samples T-Test}
\usage{
dataTOSTtwo(data, deps, group, var_equal = FALSE, low_eqbound_d = -0.5,
  high_eqbound_d = 0.5, alpha = 0.05, desc = FALSE, plots = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a vector of strings naming dependent variables in \code{data}}

\item{group}{a string naming the grouping variable in \code{data}; must 
have two levels}

\item{var_equal}{\code{TRUE} or \code{FALSE} (default), assume equal 
variances}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in 
standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in 
standardized mean difference (Cohen's d)}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide plots}
}
\description{
TOST Independent Samples T-Test
}
\section{References}{

Berger, R. L., & Hsu, J. C. (1996). Bioequivalence Trials, Intersection-Union Tests and Equivalence Confidence Sets. Statistical Science, 11(4), 283-302.

Gruman, J. A., Cribbie, R. A., & Arpin-Cribbie, C. A. (2007). The effects of heteroscedasticity on tests of equivalence. Journal of Modern Applied Statistical Methods, 6(1), 133-140, formula for Welch's t-test on page 135
}

\examples{
library(TOSTER)

## Load iris dataset, remove one of the three groups so two are left

data<-iris[which(iris$Species!="versicolor"),]

## TOST procedure on the raw data

dataTOSTtwo(data, deps="Sepal.Width", group="Species", var_equal = TRUE, low_eqbound_d = -0.5,
            high_eqbound_d = 0.5, alpha = 0.05, desc = TRUE, plots = TRUE)

}
