% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOSTtwo.raw.R
\name{TOSTtwo.raw}
\alias{TOSTtwo.raw}
\title{TOST function for an independent t-test (raw scores)}
\usage{
TOSTtwo.raw(m1, m2, sd1, sd2, n1, n2, low_eqbound, high_eqbound, alpha,
  var.equal)
}
\arguments{
\item{m1}{mean of group 1}

\item{m2}{mean of group 2}

\item{sd1}{standard deviation of group 1}

\item{sd2}{standard deviation of group 2}

\item{n1}{sample size in group 1}

\item{n2}{sample size in group 2}

\item{low_eqbound}{lower equivalence bounds (e.g., -0.5) expressed in raw scale units (e.g., scalepoints)}

\item{high_eqbound}{upper equivalence bounds (e.g., 0.5) expressed in raw scale units (e.g., scalepoints)}

\item{alpha}{alpha level (default = 0.05)}

\item{var.equal}{logical variable indicating whether equal variances assumption is assumed to be TRUE or FALSE. Defaults to FALSE.}
}
\value{
Returns TOST t-value 1, TOST p-value 1, TOST t-value 2, TOST p-value 2, degrees of freedom, low equivalence bound, high equivalence bound, Lower limit confidence interval TOST, Upper limit confidence interval TOST
}
\description{
TOST function for an independent t-test (raw scores)
}
\section{References}{

Berger, R. L., & Hsu, J. C. (1996). Bioequivalence Trials, Intersection-Union Tests and Equivalence Confidence Sets. Statistical Science, 11(4), 283-302. 

Gruman, J. A., Cribbie, R. A., & Arpin-Cribbie, C. A. (2007). The effects of heteroscedasticity on tests of equivalence. Journal of Modern Applied Statistical Methods, 6(1), 133-140, formula for Welch's t-test on page 135
}
\examples{
## Eskine (2013) showed that participants who had been exposed to organic 
## food were substantially harsher in their moral judgments relative to 
## those exposed to control (d = 0.81, 95\% CI: [0.19, 1.45]). A 
## replication by Moery & Calin-Jageman (2016, Study 2) did not observe 
## a significant effect (Control: n = 95, M = 5.25, SD = 0.95, Organic 
## Food: n = 89, M = 5.22, SD = 0.83). Following Simonsohn's (2015) 
## recommendation the equivalence bound was set to the effect size the 
## original study had 33\% power to detect (with n = 21 in each condition,
## this means the equivalence bound is d = 0.48, which equals a 
## difference of 0.384 on a 7-point scale given the sample sizes and a 
## pooled standard deviation of 0.894). Using a TOST equivalence test 
## with alpha = 0.05, assuming equal variances, and equivalence 
## bounds of d = -0.43 and d = 0.43 is significant, t(182) = -2.69, 
## p = 0.004. We can reject effects larger than d = 0.43.

TOSTtwo.raw(m1=5.25,m2=5.22,sd1=0.95,sd2=0.83,n1=95,n2=89,low_eqbound=-0.384,high_eqbound=0.384)
}

