% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HAR.TLineSeg.Norm.R
\name{HAR.TLineSeg.Norm}
\alias{HAR.TLineSeg.Norm}
\title{Gaussian-like Sampling on a max-plus tropical line segment}
\usage{
HAR.TLineSeg.Norm(D1, D2, mu, stdev)
}
\arguments{
\item{D1}{point in the tropical projective torus}

\item{D2}{point in the tropical projective torus}

\item{mu}{location parameter}

\item{stdev}{scale parameter}
}
\value{
point on the line segment defined by D1 and D2 sampled about mu
}
\description{
This function samples points on a tropical line segment about a location parameter for a given scale parameter defined in terms of tropical distance
}
\examples{
D1 <-c(0,4,2)
D2 <- c(0,7,-1)
mu<-c(0,7,2)
sd<-1
HAR.TLineSeg.Norm(D1, D2,mu,sd)

}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
