% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_update.error.R
\name{mod_update.error}
\alias{mod_update.error}
\title{Update the error matrix}
\usage{
mod_update.error(object, method, absolute.error = NULL,
  relative.error = NULL, k = 1)
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the initial TL curves.}

\item{method}{\link{character} (with default): Defines the methode use to update the error matrix ("poisson", "absolute", "relative", "combine").}

\item{absolute.error}{\link{numeric} (with default): absolute error of the TL signals (used by the "absolute" and "combine" methods).}

\item{relative.error}{\link{numeric} (with default): Relative error of the TL signals (used by the "relative" and "combine" methods).}

\item{k}{\link{numeric} (with default): corrective factor to use when using a poisson distribution for the uncertainties (used by the "poisson" method).}
}
\value{
This function provides a new \code{\linkS4class{TLum.Analysis}} with the new error matrix. \cr
}
\description{
This function update the error vector of each curve from a \code{\linkS4class{TLum.Analysis}} object.
}
\author{
David Strebler, University of Cologne (Germany).
}

