% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_TL.MAAD.average.R
\name{calc_TL.MAAD.average}
\alias{calc_TL.MAAD.average}
\title{Estimate average additive curves for the MAAD protocol.}
\usage{
calc_TL.MAAD.average(names, doses, Lx, Lx.error)
}
\arguments{
\item{names}{\link{character} (\bold{required}): Names of the TL curves}

\item{doses}{\link{numeric} (\bold{required}): additive doses used for the TL curve}

\item{Lx}{\link{numeric} (\bold{required}): Lx matrix}

\item{Lx.error}{\link{numeric} (\bold{required}): Error for the Lx matrix.}
}
\value{
The function provide an \linkS4class{TLum.Results} object containing: \cr
 \describe{
   \item{\code{names}}{
     \link{character}: Vector with the names of the average additive curves.}
   \item{\code{doses}}{
     \link{character}: Vector with the additive doses corresponding to each average additive curve.}
   \item{\code{Lx}}{
     \link{numeric}: new average additive curve Lx matrix.}
   \item{\code{Lx.error}}{
     \link{numeric}: Error on the new Lx matrix.}
 }
}
\description{
Internal function called by \link{analyse_TL.MAAD}. \cr
This function estimates the average curves for each additive dose.
}
\details{
\bold{Warning}: This function is an internal function and should not be used except for development purposes.
 Internal functions can be heavily modified and even renamed or removed in new version of the package.
}
\author{
David Strebler, University of Cologne (Germany).
}

