\name{tess.plot.multichain.diagnostics}
\alias{tess.plot.multichain.diagnostics}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{tess.plot.multichain.diagnostics: Plotting the mcmc diagnostics of a episodic diversification rate analysis with mass-extinction events.}
\description{tess.plot.multichain.diagnostics plots MCMC diagnostics for the output generated by a tess.process.output(...) command. Fore more examples see the vignette.}
\usage{
tess.plot.multichain.diagnostics(outputs,
                                      parameters=c("speciation rates",
                                                   "speciation shift times",
                                                   "extinction rates",
                                                   "extinction shift times",
                                                   "net-diversification rates",
                                                   "relative-extinction rates",
                                                   "mass extinction times"),
                                      diagnostics="Gelman-Rubin",
                                      gelman.crit=1.05,
                                      xlab="million years ago",
                                      col=NULL,
                                      xaxt="n",
                                      yaxt="s",
                                      pch=19,
                                      ...)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{outputs}{The processed output for plotting.}
  \item{parameters}{Which parameters to diagnose. See details for a complete description.}
  \item{diagnostics}{Which diagnostics to use. Currently the only option is "Rubin-Gelman".}
  \item{gelman.crit}{The critical value above which a Rubin-Gelman statistic is considered a failure.}
  \item{xlab}{The label of the x-axis. By default, millions of years.}
  \item{col}{Colors used for printing. Must be of same length as fig.types.}
  \item{xaxt}{The type of x-axis to plot. By default, no x-axis is plotted (recommended).}
  \item{yaxt}{The type of y-axis to plot.}
  \item{pch}{The type of points to draw (if points are drawn).}
  \item{...}{Arguments delegated to plot()}
}

\details{

This function generates visual summaries of multi-chain MCMC diagnostics for the CoMET analysis in the output object.
The argument parameters specifies the aspects of the model to summarize.
Valid options are:
  \itemize{
    \item{speciation rates: }{Plots the interval-specific speciation rates.}
    \item{speciation shift times: }{Plots the posterior probability of at least one speciation-rate shift for each interval.}
    \item{extinction rates: }{Plots the interval-specific extinction rates.}
    \item{extinction shift times: }{Plots the posterior probability of at least one extinction-rate shift for each interval.}
    \item{net-diversification rates}{Plots the interval-specific net-diversification rates.}
    \item{relative-extinction rates}{Plots the interval-specific relative-extinction rates.}
    \item{mass extinction times: }{Plots the posterior probability of at least one mass-extinction event for each interval.}
  }
}

\author{Michael R. May}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
# Load the data, compute the sampling fraction rho
data(conifers)
totalConiferSpecies <- 630
sampledConiferSpecies <- conifers$Nnode+1
rho <- sampledConiferSpecies / totalConiferSpecies

# Run a tess analysis
tess.analysis(tree = conifers,
              initialSpeciationRate=c(1.0),
              initialExtinctionRate=c(0.5),
              empiricalHyperPriors = FALSE,
              numExpectedRateChanges = 2,
              numExpectedMassExtinctions = 2,
              samplingProbability = rho,
              MAX_ITERATIONS = 200,
              BURNIN = 100,
              dir = "./run_1")

tess.analysis(tree = conifers,
              initialSpeciationRate=c(1.0),
              initialExtinctionRate=c(0.5),
              empiricalHyperPriors = FALSE,
              numExpectedRateChanges = 2,
              numExpectedMassExtinctions = 2,
              samplingProbability = rho,
              MAX_ITERATIONS = 200,
              BURNIN = 100,
              dir = "./run_2")

# Process the output
coniferOutput_1 <- tess.process.output(dir="./run_1",
                                     numExpectedRateChanges=2,
                                     numExpectedMassExtinctions=2)

coniferOutput_2 <- tess.process.output(dir="./run_2",
                                     numExpectedRateChanges=2,
                                     numExpectedMassExtinctions=2)

# Plot the output
outputs <- list(coniferOutput_1,coniferOutput_2)
tess.plot.multichain.diagnostics(outputs)
\dontshow{
	unlink("run_1", recursive = TRUE) 
	unlink("run_2", recursive = TRUE) 
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ htest }
%\keyword{ birth-death }% __ONLY ONE__ keyword per line
