% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEAM.R
\name{TEAM}
\alias{TEAM}
\title{Testing on an Aggregation Tree Method}
\usage{
TEAM(x1, x2, theta0 = length(x2)/length(c(x1, x2)), K = 14,
  alpha = 0.05, L = 3)
}
\arguments{
\item{x1}{Numeric vector of N1 control observations}

\item{x2}{Numeric vector of N2 case observations}

\item{theta0}{Nominal boundary level for binomial parameter - default is N2/(N1+N2)}

\item{K}{log2 number of bins}

\item{alpha}{Nominal false discovery rate (FDR) level}

\item{L}{Number of layers in the aggregation tree}
}
\value{
List containing the discoveries (S.list) in each layer and the estimated layer-specific thresholds (c.hats)
}
\description{
This function performs multiple testing embedded in a hierarchical structure in order to identify local differences between two independent distributions (e.g. case and control).
}
\examples{
set.seed(1)
# Simulate local shift difference for each population from mixture of normals
N1 <- N2 <- 1e6
require(ks) #loads rnorm.mixt function
#Controls
x1 <- rnorm.mixt(N1,mus=c(0.2,0.89),sigmas=c(0.04,0.01),props=c(0.97,0.03))
#Cases
x2 <- rnorm.mixt(N2,mus=c(0.2,0.88),sigmas=c(0.04,0.01),props=c(0.97,0.03))
res <- TEAM(x1,x2,K=14,alpha=0.05,L=3)
#Discoveries in each layer - Each element is an growing set of
#indices captured at each layer
res$S.list
#Map back final discoveries in layer 3 to corresponding regions
levels(res$dat$quant)[res$S.list[[3]]]

}
\references{
Pura J. Chan C. Xie J. Multiple Testing Embedded in an Aggregation Tree to Identify where Two Distributions Differ. \url{https://arxiv.org/abs/1906.07757}
}
