% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{rMax_modelsR}
\alias{rMax_modelsR}
\title{Compute the  Tropical Cyclone Radius of Maximum Winds}
\usage{
rMax_modelsR(
  rMaxModel,
  TClats,
  cPs,
  eP,
  R175ms = 150,
  dPdt = NULL,
  vFms = NULL,
  rho = 1.15
)
}
\arguments{
\item{rMaxModel}{0=Powell et.al.(2005),1=McInnes et.al.(2014),2=Willoughby & Rahn (2004),  3=Vickery & Wadhera (2008), 4=Takagi & Wu (2016), 5 = Chavas & Knaff (2022)}

\item{TClats}{Tropical cyclone central latitude (nautical degrees)}

\item{cPs}{Tropical cyclone central pressure (hPa)}

\item{eP}{Background environmental pressure (hPa)}

\item{R175ms}{radius of 17.5m/s wind speeds (km)}

\item{dPdt}{rate of change in central pressure over time, hPa per hour from Holland 2008}

\item{vFms}{Forward speed of the storm m/s}

\item{rho}{density of air}
}
\value{
radius of maximum winds (km)
}
\description{
Compute the  Tropical Cyclone Radius of Maximum Winds
}
\examples{
rMax_modelsR(0,-14,950,1013,200,0,0,1.15)
}
